/* Wiktor Zychla, 2003 */
using System;
using System.Threading;

namespace DelegacjeIZdarzenia
{
  public delegate void CZdarzenieDelegate( CZdarzenieEventArgs e );

  // Argumenty zdarzenia
  public class CZdarzenieEventArgs
  {
    public int informacja1;
    public int informacja2;

    private CZdarzenieEventArgs() {}
    public  CZdarzenieEventArgs( int Informacja1, int Informacja2 )
    {
      informacja1 = Informacja1;
      informacja2 = Informacja2;
    }
  }
	
  // Obiekt, ktry bdzie wysya zdarzenie
  public class CObiekt
  {
    public event CZdarzenieDelegate Zdarzenie;

    public void ZdarzenieZaszlo( CZdarzenieEventArgs e )
    {
      this.Zdarzenie(e);
    }

    public CObiekt() {}
  }

  class CMain
  {
    // Reakcja na zdarzenie
    static void Reakcja1( CZdarzenieEventArgs e )
    {
      Console.WriteLine( String.Format( "Reakcja 1: {0},{1}", 
                         e.informacja1, e.informacja2 ) );
    }

    static void Reakcja2( CZdarzenieEventArgs e )
    {
      Console.WriteLine( String.Format( "Reakcja 2: {0},{1}", 
                         e.informacja1, e.informacja2 ) );
    }

    public static void Main()
    {
      CObiekt obiekt = new CObiekt();
      obiekt.Zdarzenie += new CZdarzenieDelegate( Reakcja1 );
      Thread.Sleep(1000);
      obiekt.ZdarzenieZaszlo( new CZdarzenieEventArgs( 1, 2 ) );
      Thread.Sleep(1000);
      obiekt.Zdarzenie += new CZdarzenieDelegate( Reakcja2 );
      obiekt.ZdarzenieZaszlo( new CZdarzenieEventArgs( 3, 4 ) );
      Thread.Sleep(1000);
      Console.WriteLine( "koniec" );
    }
  }
}
